<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */


$settings = apply_filters('labb_gallery_' . $id . '_settings', $settings);

$settings->gallery_id = $id;

$module::$gallery_counter++;

$common = LABB_Gallery_Common::get_instance();

$settings->gallery_class = !empty($settings->gallery_class) ? sanitize_title($settings->gallery_class) : 'gallery-' . $module::$gallery_counter;

$items = $settings->gallery_items;

//$items = $common->parse_items($items);

if ($settings->bulk_upload == 'yes') {

    $items = array();

    $ids = $settings->gallery_images;

    if (empty($ids))
        return;

    foreach ($ids as $id):

        $item = array('item_type' => 'image', 'item_image' => $id, 'item_name' => '', 'tags' => '', 'item_link' => '','item_description' => '');

        $items[] = (object)$item;

    endforeach;

    unset($settings->gallery_images); // exclude items from settings
}
else {

    $items = $settings->gallery_items;

    unset($settings->gallery_items); // exclude items from settings

}

unset($settings->gallery_items); // exclude items from settings

if (!empty($items)) :

    $terms = $common->get_gallery_terms($items);

    $max_num_pages = 1;

    if ($settings->pagination !== 'none')
        $max_num_pages = ceil(count($items) / $settings->items_per_page);


    $output = '<div class="labb-gallery-wrap labb-gapless-grid" data-settings=\'' . wp_json_encode($module->get_settings_data_atts($settings))
        . '\' data-items=\'' . (($settings->pagination !== 'none') ? json_encode($items, JSON_HEX_APOS) : '')
        . '\' data-maxpages=\'' . $max_num_pages
        . '\' data-total=\'' . count($items)
        . '\' data-current=\'1\'>';

    if (!empty($settings->heading) || $settings->filterable == 'yes'):

        $header_class = (trim($settings->heading) === '') ? ' labb-no-heading' : '';

        $gallery_header = '<div class="labb-gallery-header ' . $header_class . '">';

        if (!empty($settings->heading)) :

            $gallery_header .= '<' . $settings->heading_tag . ' class="labb-heading">' . wp_kses_post($settings->heading) . '</' . $settings->heading_tag . '>';

        endif;

        if ($settings->bulk_upload !== 'yes' && $settings->filterable == 'yes')
            $gallery_header .= $common->get_gallery_terms_filter($terms);

        $gallery_header .= '</div>';

        $output .= apply_filters('labb_gallery_header', $gallery_header, $settings);

    endif;

    $output .= '<div id="' . uniqid('labb-gallery')
        . '" class="labb-gallery js-isotope labb-' . esc_attr($settings->layout_mode) . ' labb-grid-container ' . labb_get_grid_classes($settings) . ' ' . $settings->gallery_class
        . '" data-isotope-options=\'{ "itemSelector": ".labb-gallery-item", "layoutMode": "' . esc_attr($settings->layout_mode) . '", "masonry": { "columnWidth": ".labb-grid-sizer" } }\'>';

    if ($settings->layout_mode == 'masonry'):

        $output .= '<div class="labb-grid-sizer"></div>';

    endif;

    $items_per_page = intval($settings->items_per_page);

    // If pagination option is chosen, filter the items for the current page
    if ($settings->pagination != 'none')
        $display_items = $common->get_items_to_display($items, 1, $items_per_page);
    else
        $display_items = $items;

    $output .= $common->build_gallery($display_items, $settings);

    $output .= '</div><!-- .labb-gallery -->';

    $output .= $common->paginate_gallery($items, $settings);

    $output .= '</div><!-- .labb-gallery-wrap -->';

    echo apply_filters('labb_gallery_output', $output, $settings);

endif;